//
// (C) Copyright 1993-1998 by Autodesk, Inc.
//
// The information contained herein is confidential, proprietary  to
// Autodesk,  Inc., and considered a trade secret as defined in sec-
// tion 499C of the penal code of the State of California.   Use  of
// this information by anyone other than authorized employees of Au-
// todesk, Inc. is  granted  only  under  a  written  non-disclosure
// agreement,  expressly  prescribing  the  scope and manner of such
// use.
//
// DESCRIPTION:
//
// Dockable pane class declaration
//

#ifndef CDOCKPANE_H_
#define CDOCKPANE_H_

// PURPOSE:
// This class implements a dockable pane, MSVC-like. It is based
// on some sample code so the code still has the "sample" look.
//

#include "adesk.h"
#include "dbmain.h"
#include "adui.h" // for CAdUiDockControlBar
#include "subclass.h" // for CSubclassWnd

#include "TreeCtrlEx.h"
#include "MyPropertySheet.h"

#include "MapReactors.h"

#include <queue>
using namespace std;

class AcMapQuery;
class AcMapProject;
class AcMapQueryLibrary;
class AcMapQueryCategory;
class AcMapQueryUnit;
class AcMyDrawingSetReactor;
class AcMyQueryLibraryReactor;
class AcMapQueryLibraryReactor;
class AcMapAttachedDrawing;
class AcMapDriveAlias;
class AcMapQueryAttribute;
class AcMapLocationBoundary;

class CDockPaneWindowHook : public CSubclassWnd
{
public:
	DECLARE_DYNAMIC(CDockPaneWindowHook)
    CDockPaneWindowHook(){}
    ~CDockPaneWindowHook(){}
protected:
    // window proc to hook frame using CSubclassWnd implementation
	virtual LRESULT WindowProc(UINT msg, WPARAM wp, LPARAM lp);
};


//All we care about is the Query stuff. You could add messages for everything.
typedef enum {	MSG_QueryCategoryAdded,
				MSG_QueryCategoryDeleted,
				MSG_QueryCategoryRenamed,
				MSG_QueryAdded,
				MSG_QueryDeleted,
				MSG_QueryRenamed,
				MSG_QueryModified,
				MSG_MapInQuecentState
			} REACTOR_MSG;

#define WM_REACTOR_MSG WM_USER + 62 // Reactor Message has been posted
#define WM_PROCESS_MSG_QUEUE WM_USER + 63 // Process queue

class CDockPane : public CAdUiDockControlBar
{
	DECLARE_DYNAMIC(CDockPane)

public:
    CDockPane();
	virtual ~CDockPane();

// Operations
public:
    BOOL    Create(CWnd* pParentWnd);
    BOOL    IsWindowVisible() const;
    void    ToggleBarState(BOOL bShrinkIfDocked = TRUE);
	void	SetFloatingSize(const CSize& size);

	Adesk::Boolean OnLoadDwg();
	Adesk::Boolean OnUnloadDwg();
	void OnSaveComplete(AcDbDatabase *pDwg, const char *pActualName);

	void PostReactorMessage(WPARAM wParam, LPARAM lParam);

	//////////////////////////////////////
	//Notification from the Map Reactors
	//////////////////////////////////////

	//////////////////////////////////////
	//AcMapDrawingSetReactor
	
	// The notification that the drawing is attached to the Drawing Set
    void DrawingAttached(const AcMapAttachedDrawing *pObj);
    
    // The notification that the drawing is detached from the Drawing Set
    void DrawingDetached(unsigned long Id, const char *pcName, int level);
    
    // The notification that the  drawing is activated
    void DrawingActivated(const AcMapAttachedDrawing *pObj);
    
    // The notification that the drawing is deactivated
    void DrawingDeactivated(const AcMapAttachedDrawing *pObj);

    // The notification that the drawing settings are modified
    void DrawingSettingsModified(const AcMapAttachedDrawing *pObj);

	//////////////////////////////////////
	//AcMapAliasesReactor
	
	// The notification that the drawing is attached to the Drawing Set
    void AliasAdded(const AcMapDriveAlias *pObj);
    
    // The notification that the drawing is detached from the Drawing Set
    void AliasDeleted(const char *, const char *);

	
	//////////////////////////////////////
	//MyAcMapQueryLibraryReactor
	
	// Adding/Removing query category events.
    //
    void QueryCategoryAdded(const AcMapQueryCategory *pObj) ;
    void QueryCategoryDeleted(AcMapId Id, const char *pcName) ;

    // Renaming query category event.
    //
    void QueryCategoryRenamed(const AcMapQueryCategory *pObj) ;
    
    // Adding/Removing query events.
    //
    void QueryAdded(const AcMapQueryAttribute *pObj) ;
    void QueryDeleted(AcMapId Id, const char *pcName) ;

    // Modification query events.
    //
    void QueryRenamed(const AcMapQueryAttribute *pObj) ;
    void QueryModified(const AcMapQueryAttribute *pObj) ;

// Overrides

protected:
    //functions for keeping the focus
    void HookMiniFrame();
	void OnBarStyleChange(DWORD oldStyle, DWORD newStyle);

	//{{AFX_MSG(CDockPane)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg LRESULT OnIdleUpdateCmdUI(WPARAM wParam, LPARAM);
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	afx_msg LONG OnChangedDockedState(UINT, LONG);
	afx_msg LONG OnReactorMsg(UINT lParam, LONG wParam);
	DECLARE_MESSAGE_MAP()

// Attributes
protected:

	CDockPaneWindowHook m_MiniFrameHook;
	BOOL m_bFloating; //TRUE if we are not docked.

	virtual void SizeChanged(CRect *lpRect, BOOL bFloating, int flags);

private:
	BOOL StartReactors();
	void UpdateMapInfo();

	void InitializeTreeControls();
	
	void PopulateErrorInfo();
	
	void PopulateQueryInfo();
	void PopulateCurrentQueryInfo(AcMapProject *pProj, HTREEITEM htiParent);
	void PopulateCategoryQueryInfo(AcMapQueryLibrary *pQLib, HTREEITEM htiParent);
	void PopulateQueryBranchInfo(AcMapQueryUnit *pQueryUnit, HTREEITEM htiParent);

	void PopulateAcMapLocationCondition(AcMapQueryUnit *pQueryUnit, HTREEITEM htiParent);
	void PopulateAcMapPropertyCondition(AcMapQueryUnit *pQueryUnit, HTREEITEM htiParent);
	void PopulateAcMapDataCondition(AcMapQueryUnit *pQueryUnit, HTREEITEM htiParent);
	void PopulateAcMapSQLCondition(AcMapQueryUnit *pQueryUnit, HTREEITEM htiParent);

	void PopulateAllBoundary(const AcMapLocationBoundary *pLocationBoundary, HTREEITEM htiParent);
	void PopulatePointBoundary(const AcMapLocationBoundary *pLocationBoundary, HTREEITEM htiParent);
	void PopulateCircleBoundary(const AcMapLocationBoundary *pLocationBoundary, HTREEITEM htiParent);
	void PopulateFenceBoundary(const AcMapLocationBoundary *pLocationBoundary, HTREEITEM htiParent);
	void PopulateBufferFenceBoundary(const AcMapLocationBoundary *pLocationBoundary, HTREEITEM htiParent);
	void PopulatePolygonBoundary(const AcMapLocationBoundary *pLocationBoundary, HTREEITEM htiParent);
	void PopulateWindowBoundary(const AcMapLocationBoundary *pLocationBoundary, HTREEITEM htiParent);
	void PopulatePolylineBoundary(const AcMapLocationBoundary *pLocationBoundary, HTREEITEM htiParent);
	void PopulateBufferPolylineBoundary(const AcMapLocationBoundary *pLocationBoundary, HTREEITEM htiParent);
	void PopulateClosedPolylineBoundary(const AcMapLocationBoundary *pLocationBoundary, HTREEITEM htiParent);

	AcMapQuery* GetQuery(BOOL bIsCurrent);

	BOOL MapIsBusy();

private:
	AcMyDrawingSetReactor *m_pDSetReact;
	AcMyQueryLibraryReactor *m_pQueryLibraryReact;

	CTreeCtrlEx *m_pTree[2];
	CMyPropertySheet* m_pPropSheet;
	
	HTREEITEM m_htiSaveSetParent; // parent item
	HTREEITEM m_htiErrorParent; // parent item

	queue<REACTOR_MSG> m_MsgQueue;
	BOOL m_bIsMapBusy;
	BOOL m_bTimerRunning;
};

/////////////////////////////////////////////////////////////////////////////

#endif // CDOCKPANE_H_
